/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.lang.reflect.InvocationTargetException;
import java.security.InvalidParameterException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.JsonToNBT;
import net.minecraft.tags.ITag;
import net.minecraft.tags.Tag;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import team.creative.creativecore.common.config.ConfigTypeConveration;
import team.creative.creativecore.common.config.gui.GuiInfoStackButton;
import team.creative.creativecore.common.config.holder.ConfigKey;
import team.creative.creativecore.common.gui.GuiParent;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlock;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientBlockTag;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientFuel;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItem;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemStack;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientItemTag;
import team.creative.creativecore.common.util.ingredient.CreativeIngredientMaterial;

public abstract class CreativeIngredient {
    private static HashMap<String, Class<? extends CreativeIngredient>> types = new HashMap();
    private static HashMap<Class<? extends CreativeIngredient>, String> typesInv = new HashMap();
    private static List<Function<Object, ? extends CreativeIngredient>> objectParsers = new ArrayList<Function<Object, ? extends CreativeIngredient>>();

    public static <T extends CreativeIngredient> void registerType(String id, Class<T> classType, Function<Object, T> parser) {
        if (types.containsKey(id)) {
            throw new IllegalArgumentException("Id '" + id + "' is already taken");
        }
        try {
            classType.getConstructor(new Class[0]);
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new InvalidParameterException("The class does not contain an empty constructor");
        }
        types.put(id, classType);
        typesInv.put(classType, id);
        if (parser != null) {
            objectParsers.add(parser);
        }
    }

    public static String getId(CreativeIngredient ingredient) {
        return CreativeIngredient.getId(ingredient.getClass());
    }

    public static String getId(Class<? extends CreativeIngredient> clazz) {
        return typesInv.get(clazz);
    }

    public static Class<? extends CreativeIngredient> getClass(String id) {
        return types.get(id);
    }

    public static CreativeIngredient parse(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof CreativeIngredient) {
            return (CreativeIngredient)object;
        }
        for (int i = 0; i < objectParsers.size(); ++i) {
            try {
                CreativeIngredient ingredient = objectParsers.get(i).apply(object);
                if (ingredient == null) continue;
                return ingredient;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public static CreativeIngredient read(CompoundNBT nbt) {
        Class<? extends CreativeIngredient> classType = CreativeIngredient.getClass(nbt.func_74779_i("id"));
        if (classType == null) {
            throw new IllegalArgumentException("'" + nbt.func_74779_i("id") + "' is an invalid type");
        }
        try {
            CreativeIngredient ingredient = classType.getConstructor(new Class[0]).newInstance(new Object[0]);
            ingredient.readExtra(nbt);
            return ingredient;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }

    public CompoundNBT write(CompoundNBT nbt) {
        nbt.func_74778_a("id", CreativeIngredient.getId(this));
        this.writeExtra(nbt);
        return nbt;
    }

    protected abstract void writeExtra(CompoundNBT var1);

    protected abstract void readExtra(CompoundNBT var1);

    public abstract boolean is(ItemStack var1);

    public abstract boolean is(CreativeIngredient var1);

    public abstract ItemStack getExample();

    public abstract CreativeIngredient copy();

    public boolean equals(Object object) {
        return object instanceof CreativeIngredient && this.equals((CreativeIngredient)object);
    }

    public abstract boolean equals(CreativeIngredient var1);

    static {
        CreativeIngredient.registerType("block", CreativeIngredientBlock.class, x -> {
            Block block = null;
            if (x instanceof Block) {
                block = (Block)x;
            }
            if (x instanceof BlockItem) {
                block = Block.func_149634_a((Item)((Item)x));
            }
            if (block != null && !(block instanceof AirBlock)) {
                return new CreativeIngredientBlock(block);
            }
            return null;
        });
        CreativeIngredient.registerType("blocktag", CreativeIngredientBlockTag.class, x -> {
            if (x instanceof Tag && !((Tag)x).func_230236_b_().isEmpty() && ((Tag)x).func_230236_b_().iterator().next() instanceof Block) {
                return new CreativeIngredientBlockTag((ITag<Block>)((Tag)x));
            }
            return null;
        });
        CreativeIngredient.registerType("item", CreativeIngredientItem.class, x -> {
            if (x instanceof Item && !(x instanceof BlockItem)) {
                return new CreativeIngredientItem((Item)x);
            }
            return null;
        });
        CreativeIngredient.registerType("itemtag", CreativeIngredientItemTag.class, x -> {
            if (x instanceof Tag && !((Tag)x).func_230236_b_().isEmpty() && ((Tag)x).func_230236_b_().iterator().next() instanceof Item) {
                return new CreativeIngredientItemTag((ITag<Item>)((Tag)x));
            }
            return null;
        });
        CreativeIngredient.registerType("itemstack", CreativeIngredientItemStack.class, x -> x instanceof ItemStack ? new CreativeIngredientItemStack((ItemStack)x, false) : null);
        CreativeIngredient.registerType("material", CreativeIngredientMaterial.class, x -> x instanceof Material ? new CreativeIngredientMaterial((Material)x) : null);
        CreativeIngredient.registerType("fuel", CreativeIngredientFuel.class, null);
        final CreativeIngredientBlock temp = new CreativeIngredientBlock(Blocks.field_150346_d);
        ConfigTypeConveration.registerSpecialType(x -> CreativeIngredient.class.isAssignableFrom((Class<?>)x), new ConfigTypeConveration.SimpleConfigTypeConveration<CreativeIngredient>(){

            @Override
            public CreativeIngredient readElement(CreativeIngredient defaultValue, boolean loadDefault, JsonElement element) {
                if (element.isJsonPrimitive() && ((JsonPrimitive)element).isString()) {
                    try {
                        return CreativeIngredient.read(JsonToNBT.func_180713_a((String)element.getAsString()));
                    }
                    catch (CommandSyntaxException e) {
                        e.printStackTrace();
                    }
                }
                return defaultValue;
            }

            @Override
            public JsonElement writeElement(CreativeIngredient value, CreativeIngredient defaultValue, boolean saveDefault) {
                return new JsonPrimitive(value.write(new CompoundNBT()).toString());
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void createControls(GuiParent parent, Class clazz, int recommendedWidth) {
                parent.add(new GuiInfoStackButton("data", 0, 0, parent.getWidth() - 50, 18, temp));
                parent.setHeight(18);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            public void loadValue(CreativeIngredient value, GuiParent parent) {
                GuiInfoStackButton button = (GuiInfoStackButton)parent.get("data");
                button.set(value);
            }

            @Override
            @OnlyIn(value=Dist.CLIENT)
            protected CreativeIngredient saveValue(GuiParent parent, Class clazz) {
                GuiInfoStackButton button = (GuiInfoStackButton)parent.get("data");
                return button.get();
            }

            @Override
            public CreativeIngredient set(ConfigKey.ConfigKeyField key, CreativeIngredient value) {
                return value;
            }

            @Override
            public CreativeIngredient createPrimitiveDefault(Class clazz) {
                return null;
            }
        });
    }
}

